﻿
using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

using UnityEngine;

using Verse;
using Verse.AI;
using Verse.Sound;
using RimWorld;

using RimWorldChildren;

namespace rjw
{
    public static class xxx {
        public static BindingFlags ins_public_or_no = BindingFlags.Instance | BindingFlags.Public | BindingFlags.NonPublic;

        public static config config = DefDatabase<config>.GetNamed("the_one");

        public const float base_sat_per_fuck = 0.40f;

        public const float base_attraction = 0.60f;

        public const float no_partner_ability = 0.65f;

        public static TraitDef nymphomaniac = TraitDef.Named("Nymphomaniac");
        public static TraitDef rapist = TraitDef.Named("Rapist");
        public static TraitDef necrophiliac = TraitDef.Named("Necrophiliac");

        // Will be set in init. Can't be set earlier because the genitals part has to be injected first.
        public static BodyPartRecord genitals = null;
        public static BodyPartRecord breasts = null;
        public static BodyPartRecord anus = null;

        public static ThoughtDef saw_rash_1 = DefDatabase<ThoughtDef>.GetNamed("SawDiseasedPrivates1");
        public static ThoughtDef saw_rash_2 = DefDatabase<ThoughtDef>.GetNamed("SawDiseasedPrivates2");
        public static ThoughtDef saw_rash_3 = DefDatabase<ThoughtDef>.GetNamed("SawDiseasedPrivates3");

        public static ThoughtDef got_raped = DefDatabase<ThoughtDef>.GetNamed("GotRaped");
        public static ThoughtDef got_raped_by_animal = DefDatabase<ThoughtDef>.GetNamed("GotRapedByAnimal");
        public static ThoughtDef masochist_got_raped = DefDatabase<ThoughtDef>.GetNamed("MasochistGotRaped");
        public static ThoughtDef masochist_got_raped_by_animal = DefDatabase<ThoughtDef>.GetNamed("MasochistGotRapedByAnimal");
        public static ThoughtDef hate_my_rapist = DefDatabase<ThoughtDef>.GetNamed("HateMyRapist");
        public static ThoughtDef kinda_like_my_rapist = DefDatabase<ThoughtDef>.GetNamed("KindaLikeMyRapist");
        public static ThoughtDef allowed_me_to_get_raped = DefDatabase<ThoughtDef>.GetNamed("AllowedMeToGetRaped");
        public static ThoughtDef stole_some_lovin = DefDatabase<ThoughtDef>.GetNamed("StoleSomeLovin");
        public static ThoughtDef bloodlust_stole_some_lovin = DefDatabase<ThoughtDef>.GetNamed("BloodlustStoleSomeLovin");
        public static ThoughtDef violated_corpse = DefDatabase<ThoughtDef>.GetNamed("ViolatedCorpse");

        public static JobDef gettin_loved = DefDatabase<JobDef>.GetNamed("GettinLoved");
        public static JobDef nymph_rapin = DefDatabase<JobDef>.GetNamed("NymphJoinInBed");
        public static JobDef gettin_raped = DefDatabase<JobDef>.GetNamed("GettinRaped");
        public static JobDef comfort_prisoner_rapin = DefDatabase<JobDef>.GetNamed("ComfortPrisonerRapin");

        public static ThingDef mote_noheart = ThingDef.Named("Mote_NoHeart");

        public static StatDef sex_stat = StatDef.Named("SexAbility");
        public static StatDef vulnerability_stat = StatDef.Named("Vulnerability");

        public static ThingDef cum = ThingDef.Named("FilthCum");

        private static readonly SimpleCurve attractiveness_from_age_male = new SimpleCurve
        {
            new CurvePoint(00f, 0.00f),
            new CurvePoint(5f,  0.6f),
            new CurvePoint(15f, 0.8f),
            new CurvePoint(22f, 1.0f),
            new CurvePoint(30f, 0.9f),
            new CurvePoint(45f, 0.8f),
            new CurvePoint(60f, 0.7f),
            new CurvePoint(80f, 0.6f)
        };

        private static readonly SimpleCurve attractiveness_from_age_female = new SimpleCurve
        {
            new CurvePoint(00f, 0.00f),
            new CurvePoint(5f,  0.8f),
            new CurvePoint(14f, 1.0f),
            new CurvePoint(20f, 0.9f),
            new CurvePoint(30f, 0.8f),
            new CurvePoint(45f, 0.7f),
            new CurvePoint(60f, 0.5f),
            new CurvePoint(80f, 0.3f)
        };

        public static void init() {
            genitals = BodyDefOf.Human.AllParts.Find((BodyPartRecord bpr) => String.Equals(bpr.def.defName, "Genitals"));
            breasts = BodyDefOf.Human.AllParts.Find((BodyPartRecord bpr) => String.Equals(bpr.def.defName, "Chest"));
            anus = BodyDefOf.Human.AllParts.Find((BodyPartRecord bpr) => String.Equals(bpr.def.defName, "Anus"));
        }

        public static void bootstrap(Pawn p, Map m) {
            if (m.GetComponent<MapCom_Injector>() == null)
                m.components.Add(new MapCom_Injector(m));
        }

        public static bool is_psychopath(Pawn pawn) {
            return (pawn != null && pawn.story == null && pawn.story.traits != null && pawn.story.traits.HasTrait(TraitDefOf.Psychopath));
        }

        public static bool is_bloodlust(Pawn pawn) {
            return (pawn != null && pawn.story == null && pawn.story.traits != null && pawn.story.traits.HasTrait(TraitDefOf.Bloodlust));
        }

        public static bool is_brawler(Pawn pawn) {
            return (pawn != null && pawn.story != null && pawn.story.traits != null && pawn.story.traits.HasTrait(TraitDefOf.Brawler));
        }

        public static bool is_kind(Pawn pawn) {
            return (pawn != null && pawn.story != null && pawn.story.traits != null && pawn.story.traits.HasTrait(TraitDefOf.Kind));
        }

        public static bool is_rapist(Pawn pawn) {
            return (pawn != null && pawn.story != null && pawn.story.traits != null && pawn.story.traits.HasTrait(TraitDef.Named("Rapist")));
        }

        public static bool is_necrophiliac(Pawn pawn) {
            return (pawn != null && pawn.story != null && pawn.story.traits != null && pawn.story.traits.HasTrait(TraitDef.Named("Necrophiliac")));
        }

        public static bool is_zoophiliac(Pawn pawn) {
            return (pawn != null && pawn.story != null && pawn.story.traits != null && pawn.story.traits.HasTrait(TraitDef.Named("Zoophiliac")));
        }


        public static bool is_masochist(Pawn pawn) {
            return (pawn != null && pawn.story != null && pawn.story.traits != null && pawn.story.traits.HasTrait(TraitDef.Named("Masochist")));
        }

        public static bool is_nympho(Pawn pawn) {
            return (pawn != null && pawn.story != null && pawn.story.traits != null && pawn.story.traits.HasTrait(TraitDef.Named("Nymphomaniac")));
        }

        public static bool is_gay(Pawn pawn) {
            return (pawn != null && pawn.story != null && pawn.story.traits != null && pawn.story.traits.HasTrait(TraitDefOf.Gay));
        }

        public static bool is_animal(Pawn pawn) {

            return !pawn.RaceProps.Humanlike;
        }

        public static bool is_tooluser(Pawn pawn) {
            return pawn.RaceProps.intelligence >= Intelligence.ToolUser;
        }

        public static Gender opposite_gender(Gender g) {
            if (g == Gender.Male)
                return Gender.Female;
            else if (g == Gender.Female)
                return Gender.Male;
            else
                return Gender.None;
        }

        public static float get_sex_ability(Pawn p) {
            return p.GetStatValue(sex_stat, false);
        }

        public static bool can_fuck(Pawn pawn) {
            if (!xxx.is_animal(pawn)) {
                return (pawn.ageTracker.AgeBiologicalYears >= HugsLibInj.sex_minimum_age) && (pawn.ageTracker.AgeBiologicalYears >= HugsLibInj.sex_free_for_all_age) && (get_sex_ability(pawn) > 0.0f) && (!Genital_Helper.genitals_blocked(pawn));
            } else if (xxx.is_animal(pawn) && xxx.config.animals_enabled) {
                //return true;
                return (pawn.ageTracker.AgeBiologicalYears >= xxx.config.sex_minimum_age) && (get_sex_ability(pawn) > 0.0f);
            }
            return false;
        }

        public static bool can_get_raped(Pawn pawn) {
            // Pawns can still get raped even if their genitals are destroyed/removed.
            // Animals can always be raped regardless of age
            if (!xxx.is_animal(pawn)) {
                var age = pawn.ageTracker.AgeBiologicalYears;
                return (age >= HugsLibInj.sex_minimum_age) && (age >= HugsLibInj.sex_free_for_all_age) && (!Genital_Helper.genitals_blocked(pawn));
            } else if (xxx.is_animal(pawn) && xxx.config.animals_enabled) {
                return true;
            }
            return false;
        }

        // Returns how fuckable 'fucker' thinks 'p' is on a scale from 0.0 to 1.0
        public static float would_fuck(Pawn fucker, Pawn p, bool invert_opinion = false) {
            var fucker_age = fucker.ageTracker.AgeBiologicalYears;
            var p_age = p.ageTracker.AgeBiologicalYears;
            //var log_msg = "would_fuck() - fucker = " + fucker.Name + ", pawn = " + p.Name;
            //Log.Message(log_msg);

            bool age_ok;
            {
                //var ffa_age = config.sex_free_for_all_age;
                //if (xxx.is_animal(fucker) && xxx.config.animals_enabled && (p_age >= xxx.config.sex_free_for_all_age)) {
                if (xxx.is_animal(fucker) && xxx.config.animals_enabled && (p_age >= HugsLibInj.sex_free_for_all_age)) {
                    age_ok = true;
                } else if (xxx.is_animal(p) && xxx.config.animals_enabled && (fucker_age >= HugsLibInj.sex_free_for_all_age)) {
                    // don't check the age of animals when they are the victim
                    age_ok = true;
                    //} else if ((fucker_age >= xxx.config.sex_free_for_all_age) && (p_age >= xxx.config.sex_free_for_all_age)) {
                } else if ((fucker_age >= HugsLibInj.sex_free_for_all_age) && (p_age >= HugsLibInj.sex_free_for_all_age)) {
                    age_ok = true;
                    //} else if ((fucker_age < xxx.config.sex_minimum_age) || (p_age < xxx.config.sex_minimum_age)) {
                } else if ((fucker_age < HugsLibInj.sex_minimum_age) || (p_age < HugsLibInj.sex_minimum_age)) {
                    age_ok = false;
                } else {
                    age_ok = Math.Abs(fucker.ageTracker.AgeBiologicalYearsFloat - p.ageTracker.AgeBiologicalYearsFloat) < 2.05f;
                }
            }

            //Log.Message("would_fuck() - age_ok = " + age_ok.ToString());
            if (age_ok) {
                if ((!(fucker.Dead || p.Dead)) &&
                    (!(fucker.needs.food.Starving || p.needs.food.Starving)) &&
                    (fucker.health.hediffSet.BleedRateTotal <= 0.0f) && (p.health.hediffSet.BleedRateTotal <= 0.0f)) {

                    float orientation_factor;
                    {
                        Gender seeking = (!is_gay(fucker)) ? opposite_gender(fucker.gender) : fucker.gender;
                        if (p.gender == seeking)
                            orientation_factor = 1.0f;
                        else {
                            if ((fucker.gender == Gender.Female) && (p.gender == Gender.Female)) // High chance for casual lesbianism so e.g. nymphs are willing to fuck each other
                                orientation_factor = 0.4f;
                            else
                                orientation_factor = 0.1f;
                        }
                    }
                    //Log.Message("would_fuck() - orientation_factor = " + orientation_factor.ToString());

                    float age_factor = (p.gender == Gender.Male) ? attractiveness_from_age_male.Evaluate(p_age) : attractiveness_from_age_female.Evaluate(p_age);
                    //Log.Message("would_fuck() - age_factor = " + age_factor.ToString());

                    if (xxx.is_animal(fucker)) {
                        age_factor = 1.0f;
                    }
                    //Log.Message("would_fuck() - animal age_factor = " + age_factor.ToString());

                    float body_factor;
                    {
                        if (p.story != null) {
                            if (p.story.bodyType == BodyType.Female) body_factor = 1.25f;
                            else if (p.story.bodyType == BodyType.Fat) body_factor = 0.50f;
                            else body_factor = 1.00f;

                            if (RelationsUtility.IsDisfigured(p))
                                body_factor *= 0.7f;
                        } else {
                            body_factor = 1.0f;
                        }
                    }
                    //Log.Message("would_fuck() - body_factor = " + body_factor.ToString());

                    float trait_factor;
                    {
                        if (p.story != null) {
                            var deg = p.story.traits.DegreeOfTrait(TraitDefOf.Beauty);
                            trait_factor = 1.0f + 0.25f * (float)deg;
                        } else {
                            trait_factor = 1.0f;
                        }
                    }
                    //Log.Message("would_fuck() - trait_factor = " + trait_factor.ToString());

                    float opinion_factor;
                    {
                        if (p.relations != null) {
                            var opi = (float)((!invert_opinion) ? fucker.relations.OpinionOf(p) : 100 - fucker.relations.OpinionOf(p)); // -100 to 100
                            opinion_factor = 0.5f + (opi + 100.0f) * (0.8f / 200.0f); // 0.5 to 1.3
                        } else {
                            opinion_factor = 1.0f;
                        }
                    }
                    //Log.Message("would_fuck() - opinion_factor = " + opinion_factor.ToString());

                    float horniness_factor;
                    {
                        var need_sex = fucker.needs.TryGetNeed<Need_Sex>();
                        if (need_sex != null) {
                            if (need_sex.CurLevel <= need_sex.thresh_frustrated()) horniness_factor = 2.5f;
                            else if (need_sex.CurLevel <= need_sex.thresh_horny()) horniness_factor = 1.7f;
                            else horniness_factor = 1.0f;
                        } else
                            horniness_factor = 1.0f;
                    }
                    //Log.Message("would_fuck() - horniness_factor = " + horniness_factor.ToString());

                    var prenymph_att = Mathf.Clamp01(base_attraction * orientation_factor * age_factor * body_factor * trait_factor * opinion_factor * horniness_factor);
                    var final_att = (!is_nympho(fucker)) ? prenymph_att : 0.25f + 0.75f * prenymph_att;
                    //Log.Message("would_fuck( " + fucker.Name + ", " + p.Name + " ) - prenymph_att = " + prenymph_att.ToString() + ", final_att = " + final_att.ToString());

                    return final_att;

                } else
                    return 0.0f;
            } else
                return 0.0f;
        }

        public static void satisfy(Pawn pawn, Pawn part, bool violent = false) {
            string pawn_name = (pawn != null) ? pawn.NameStringShort : "NULL";
            string part_name = (part != null) ? part.NameStringShort : "NULL";
            Log.Message("xxx::satisfy( " + pawn_name + ", " + part_name + ", " + violent + " ) called");
            var base_satisfaction_per_event = base_sat_per_fuck;
            var pawn_ability = get_sex_ability(pawn);
            var part_ability = (part != null) ? get_sex_ability(part) : no_partner_ability;

            Log.Message("xxx::satisfy( " + pawn_name + ", " + part_name + ", " + violent + " ) - calculate base satisfaction");
            // Base satisfaction is based on partner's ability
            var pawn_satisfaction = base_satisfaction_per_event * part_ability;
            var part_satisfaction = base_satisfaction_per_event * pawn_ability;

            Log.Message("xxx::satisfy( " + pawn_name + ", " + part_name + ", " + violent + " ) - modifying pawn satisfaction");
            if (xxx.is_rapist(pawn) || xxx.is_bloodlust(pawn)) {
                // Rapists and Bloodlusts get more satisfaction from violetn encounters
                // Rapists and Bloodlusts get less satisfaction from non-violent encounters
                pawn_satisfaction *= (violent) ? 1.20f : 0.8f;
            } else {
                // non-violent pawns get less satisfaction from violent encounters
                // non-violent pawns get full satisfaction from non-violent encounters
                pawn_satisfaction *= (violent) ? 0.8f : 1.0f;
            }

            Log.Message("xxx::satisfy( " + pawn_name + ", " + part_name + ", " + violent + " ) - modifying part satisfaction");
            if (xxx.is_masochist(part)) {
                // masochists get some satisfaction from violent encounters
                // masochists get less satisfaction from non-violent encounters
                part_satisfaction *= (violent) ? 0.8f : 0.5f;
            } else {
                // non-masochists get little satisfaction from violent encounters
                // non-masochists get full satisfaction from non-violent encounters
                part_satisfaction *= (violent) ? 0.1f : 1.0f;
            }

            Log.Message("xxx::satisfy( " + pawn_name + ", " + part_name + ", " + violent + " ) - setting pawn joy");
            if (pawn != null && pawn.needs != null && pawn.needs.joy != null) {
                pawn.needs.TryGetNeed<Need_Sex>().CurLevel += pawn_satisfaction;
                pawn.needs.joy.CurLevel += pawn_satisfaction * 0.50f;       // convert half of satisfaction to joy
            }

            Log.Message("xxx::satisfy( " + pawn_name + ", " + part_name + ", " + violent + " ) - setting part joy");
            if (part != null && part.needs != null && part.needs.joy != null) {
                part.needs.TryGetNeed<Need_Sex>().CurLevel += part_satisfaction;
                part.needs.joy.CurLevel += part_satisfaction * 0.50f;       // convert half of satisfaction to joy
            }

            Log.Message("xxx::satisfy( " + pawn_name + ", " + part_name + ", " + violent + " ) - pawn_satisfaction = " + pawn_satisfaction + ", part_satisfaction = " + part_satisfaction);

        }

        public static bool bed_has_at_least_two_occupants(Building_Bed bed) {
            int occupantc = 0;
            foreach (var occ in bed.CurOccupants)
                if (++occupantc >= 2)
                    break;
            return occupantc >= 2;
        }

        public static bool is_laying_down_alone(Pawn p) {
            if ((p.CurJob == null) ||
                (p.jobs.curDriver.layingDown == LayingDownState.NotLaying))
                return false;

            Building_Bed bed = null;

            if (p.jobs.curDriver is JobDriver_LayDown) {
                bed = ((JobDriver_LayDown)p.jobs.curDriver).Bed;
            }

            if (bed != null)
                return !bed_has_at_least_two_occupants(bed);
            else
                return true;
        }

        public static int generate_min_ticks_to_next_lovin(Pawn pawn) {
            if (!DebugSettings.alwaysDoLovin) {
                float interval = rjw_CORE_EXPOSED.JobDriver_Lovin.LovinIntervalHoursFromAgeCurve.Evaluate(pawn.ageTracker.AgeBiologicalYearsFloat);
                float rinterval = Math.Max(0.5f, Rand.Gaussian(interval, 0.3f));

                float tick = 1.0f;

                if (xxx.is_animal(pawn) || xxx.is_nympho(pawn)) {
                    tick = 0.5f;
                }

                return (int)(tick * rinterval * 2500.0f);
            } else {
                return 100;
            }
        }


        public static void sexTick(Pawn pawn, Pawn partner) {
            pawn.Drawer.rotator.Face(partner.DrawPos);

            if (xxx.config.sounds_enabled) {
                SoundDef.Named("Sex").PlayOneShot(new TargetInfo(partner.Position, partner.Map, false));
            }

            pawn.Drawer.Notify_MeleeAttackOn(partner);
            pawn.Drawer.rotator.FaceCell(partner.Position);
        }

        public static void think_after_sex(Pawn pawn, Pawn part, bool violent = false) {
            Log.Message("xxx::think_after_sex( " + pawn.NameStringShort + ", " + part.NameStringShort + ", " + violent + " ) called");

            Log.Message("xxx::think_after_sex( " + pawn.NameStringShort + ", " + part.NameStringShort + ", " + violent + " ) - setting pawn thoughts");
            // pawn thoughts
            if (!xxx.is_animal(pawn)) {
                var pawn_thought = (violent && xxx.is_rapist(pawn) || xxx.is_bloodlust(pawn)) ? xxx.bloodlust_stole_some_lovin : xxx.stole_some_lovin;
                pawn.needs.mood.thoughts.memories.TryGainMemory(pawn_thought);

                if (xxx.is_necrophiliac(pawn) && part.Dead) {
                    pawn.needs.mood.thoughts.memories.TryGainMemory(xxx.violated_corpse);
                }
            }

            Log.Message("xxx::think_after_sex( " + pawn.NameStringShort + ", " + part.NameStringShort + ", " + violent + " ) - setting part thoughts");
            // partner thoughts
            if (!xxx.is_animal(part) && violent) {
                if (xxx.is_animal(pawn)) {
                    var part_thought = (xxx.is_masochist(part)) ? xxx.masochist_got_raped_by_animal : xxx.got_raped_by_animal;
                    part.needs.mood.thoughts.memories.TryGainMemory(part_thought);
                } else {
                    var part_thought = (xxx.is_masochist(part)) ? xxx.masochist_got_raped : xxx.got_raped;
                    part.needs.mood.thoughts.memories.TryGainMemory(part_thought);

                    var part_thought_about_rapist = (!xxx.is_masochist(part)) ? xxx.hate_my_rapist : xxx.kinda_like_my_rapist;
                    part.needs.mood.thoughts.memories.TryGainMemory(part_thought_about_rapist, pawn);
                }

                foreach (var bystander in part.Map.mapPawns.SpawnedPawnsInFaction(part.Faction)) {
                    if ((bystander != pawn) && (bystander != part) && !xxx.is_animal(bystander)) {
                        part.needs.mood.thoughts.memories.TryGainMemory(xxx.allowed_me_to_get_raped, bystander);
                    }
                }
            }

            Log.Message("xxx::think_after_sex( " + pawn.NameStringShort + ", " + part.NameStringShort + ", " + violent + " ) - setting disease thoughts");
            // check for visible diseases
            if (!xxx.is_animal(pawn) && !xxx.is_animal(part)) {
                // Add negative relation for visible diseases on the genitals
                var pawn_rash_severity = std.genital_rash_severity(pawn) - std.genital_rash_severity(part);
                ThoughtDef pawn_thought_about_rash = null;
                if (pawn_rash_severity == 1) pawn_thought_about_rash = saw_rash_1;
                else if (pawn_rash_severity == 2) pawn_thought_about_rash = saw_rash_2;
                else if (pawn_rash_severity >= 3) pawn_thought_about_rash = saw_rash_3;
                if (pawn_thought_about_rash != null) {
                    var memory = (Thought_Memory)ThoughtMaker.MakeThought(pawn_thought_about_rash);
                    pawn.needs.mood.thoughts.memories.TryGainMemory(memory, part);
                }

                var part_rash_severity = std.genital_rash_severity(part) - std.genital_rash_severity(pawn);
                ThoughtDef part_thought_about_rash = null;
                if (part_rash_severity == 1) part_thought_about_rash = saw_rash_1;
                else if (part_rash_severity == 2) part_thought_about_rash = saw_rash_2;
                else if (part_rash_severity >= 3) part_thought_about_rash = saw_rash_3;
                if (part_thought_about_rash != null) {
                    var memory = (Thought_Memory)ThoughtMaker.MakeThought(part_thought_about_rash);
                    part.needs.mood.thoughts.memories.TryGainMemory(memory, pawn);
                }


            }
        }

        // Should be called after "pawn" has fucked "partner"
        // "rapist" can be set to either "pawn" or "partner", or null if no rape occurred
        public static void aftersex(Pawn pawn, Pawn part, bool violent = false) {
            var pawn_name = (pawn != null) ? pawn.NameStringShort : "NULL";
            var part_name = (pawn != null) ? part.NameStringShort : "NULL";
            Log.Message("xxx::aftersex( " + pawn_name + ", " + part_name + " ) called");
            pawn.Drawer.rotator.Face(part.DrawPos);
            pawn.Drawer.rotator.FaceCell(part.Position);

            part.Drawer.rotator.Face(pawn.DrawPos);
            part.Drawer.rotator.FaceCell(pawn.Position);

            if (violent) {
                pawn.Drawer.Notify_MeleeAttackOn(part);
            }

            if (xxx.config.sounds_enabled) {
                SoundDef.Named("Cum").PlayOneShot(new TargetInfo(part.Position, pawn.Map, false));
            }

            Log.Message("xxx::aftersex( " + pawn_name + ", " + part_name + " ) - applying cum effect");
            if (xxx.config.cum_enabled) {
                var pawn_cum = xxx.is_animal(pawn) ? 3 : (int)(pawn.RaceProps.lifeExpectancy / pawn.ageTracker.AgeBiologicalYears);
                var part_cum = xxx.is_animal(pawn) ? 3 : (int)(part.RaceProps.lifeExpectancy / part.ageTracker.AgeBiologicalYears);
                FilthMaker.MakeFilth(pawn.PositionHeld, pawn.MapHeld, cum, pawn.LabelIndefinite(), pawn_cum);
                FilthMaker.MakeFilth(part.PositionHeld, part.MapHeld, cum, part.LabelIndefinite(), part_cum);
            }

            Log.Message("xxx::aftersex( " + pawn_name + ", " + part_name + " ) - checking satisfaction");
            satisfy(pawn, part, violent);
            Log.Message("xxx::aftersex( " + pawn_name + ", " + part_name + " ) - checking thoughts");
            think_after_sex(pawn, part, violent);

            Log.Message("xxx::aftersex( " + pawn_name + ", " + part_name + " ) - checking pregnancy");
            impregnate(pawn, part);

            Log.Message("xxx::aftersex( " + pawn_name + ", " + part_name + " ) - checking disease");
            std.roll_to_catch(pawn, part);
        }

        public static void impregnate(Pawn pawn, Pawn part) {
            if (pawn == null || part == null) return;
            Log.Message("xxx::impregnate( " + pawn.NameStringShort + ", " + part.NameStringShort + " ) called");

            Pawn male, female;
            if (pawn.gender == Gender.Male && part.gender == Gender.Female) {
                male = pawn;
                female = part;
            } else if (pawn.gender == Gender.Female && part.gender == Gender.Male) {
                male = part;
                female = pawn;
            } else {
                Log.Message("[RJW] Same sex pregnancies not currently supported...");
                return;
            }

            if (!xxx.is_animal(female) && !xxx.is_animal(male)) {
                try {
                    TryImpregnate_RimWorldChildren(female, male);
                    return;
                } catch (System.TypeLoadException) {
                    Log.Message("[RJW] RimWorldChildren does not appear to be available, reverting to default pregnancy method");
                }
            } else {
                Log.Message("[RJW] Can't use RimWorldChildren for hybrid pregnancies, using default");
            }

            // fertility check
            float fertility = 1.0f;
            float pregnancy_threshold = fertility * Math.Max(1 - (Math.Max(female.ageTracker.AgeBiologicalYearsFloat - 25, 0) / 25), 0) * 0.33f;
            float pregnancy_chance = Rand.Value;

            if (pregnancy_chance > pregnancy_threshold) {
                Log.Message("[RJW] Impregnation failed. Chance was " + pregnancy_chance + " vs " + pregnancy_threshold);
                return;
            }

            Hediff_Pregnant hediff_pregnant = (Hediff_Pregnant)HediffMaker.MakeHediff(HediffDef.Named("Pregnant"), female);
            hediff_pregnant.father = male;
            female.health.AddHediff(hediff_pregnant);
            Log.Message("[RJW] Impregnation succeeded. Chance was " + pregnancy_chance + " vs " + pregnancy_threshold);

        }

        public static void TryImpregnate_RimWorldChildren(Pawn female, Pawn male) {
            // fertility check
            float fertility = 1.0f;
            float pregnancy_threshold = fertility * Math.Max(1 - (Math.Max(female.ageTracker.AgeBiologicalYearsFloat - 25, 0) / 25), 0) * 0.33f;
            float pregnancy_chance = Rand.Value;

            BodyPartRecord torso = female.RaceProps.body.AllParts.Find(x => x.def == BodyPartDefOf.Torso);
            var human_pregnancy = DefDatabase<HediffDef>.GetNamed("HumanPregnancy", false);
            if (female.health.hediffSet.HasHediff(HediffDefOf.Pregnant) || female.health.hediffSet.HasHediff(human_pregnancy, torso)) {
                Log.Message("[RJW] C&P target is already pregnant, bailing");
                return;
            }

            var contraceptive = DefDatabase<HediffDef>.GetNamed("Contraceptive", false);
            if (female.health.hediffSet.HasHediff(contraceptive, null) || male.health.hediffSet.HasHediff(contraceptive, null)) {
                pregnancy_threshold = 0.0f;
            }

            if (pregnancy_chance > pregnancy_threshold) {
                Log.Message("[RJW] C&P impregnation failed. Chance was " + pregnancy_chance + " vs " + pregnancy_threshold);
                return;
            }

            Hediff_HumanPregnancy hediff_Pregnant = (Hediff_HumanPregnancy)HediffMaker.MakeHediff(HediffDef.Named("HumanPregnancy"), female, torso);
            hediff_Pregnant.father = male;
            female.health.AddHediff(hediff_Pregnant, torso, null);
            Log.Message("[RJW] C&P impregnation succeeded. Chance was " + pregnancy_chance + " vs " + pregnancy_threshold);

        }

        public static bool AttemptAnalRape(Pawn rapist, Pawn victim) {
            //Log.Message(rapist.NameStringShort + " is attempting to anally rape " + victim.NameStringShort);
            return true;
        }
    }

}
